<?php
// ++=========================================================================++
// || vBadvanced Links Directory v1.0.0 RC3                                   
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || =-=-=-=+_++_+_+_+_+_+_+_+__+_+_++_+_+__+_+_+_+_++_+_+_+_+_+_+_+_=-=-=-=-=-
// || You are downloading a Ripped/Scripts that is not made by http://club2share.com staff.
// || Anything that happen because of running the Ripped/Scripts is not a responsibility of
// || clubshare staff. Downloading and opening the Ripped/Scripts is at your own risk.  Thank
// ||  you very much!  
// ||----------------------------------------------------------------------------
// ||Ripped By : Vb_IPB_RIP Member Of Club2Share
// ||Download  : Club2Share.Com
// ||Price     : $34.99
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$specialtemplates = array(
	'adv_links_opts',
	'links_d_cache',
	'links_mod_cache'
);

$phrasegroups = array(
	'adv_links',
	'adv_links_cp'
);

require_once('./global.php');
require_once('./includes/functions_links.php');
require_once('./includes/adminfunctions_links.php');

$vba_options = unserialize($datastore['adv_links_opts']);

print_cp_header($vbphrase['links_admin']);

if (!$_BITFIELD['usergroup']['linkspermissions'])
{
	print_form_header('', '');
	print_table_header('Error!');
	print_description_row($vbphrase['adv_links_warning_file_changes']);
	print_table_footer();
	exit;
}

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'dirmanager';
}

// ######################## Get options array ###################################
if (in_array($_REQUEST['do'], array('viewlinks', 'maintenance')))
{
	$orderopts = array(
		'linkid' => $vbphrase['linkid'], 
		'name' => $vbphrase['title'], 
		'dateline' => $vbphrase['date_added'], 
		'rating' => $vbphrase['rating'], 
		'posts' => $vbphrase['number_of_replies'], 
		'username' => $vbphrase['username'], 
		'lastpostdateline' => $vbphrase['last_posting_date']
	);

	$diropts = array(
		'ASC' => $vbphrase['ascending'], 
		'DESC' => $vbphrase['descending']
	);

	$perpageopts = array(10 => 10, 25 => 25, 50 => 50, 75 => 75, 100 => 100, 250 => 250, 500 => 500, 1000 => 1000);
}

// ###################### Custom Field Types ##############################
$customfieldtypes = array(
	'text' => $vbphrase['text_input_single_line'], 
	'textarea' => $vbphrase['textarea_multiple_line'], 
	'select' => $vbphrase['select_preset_options'], 
	'radio' => $vbphrase['radio_options_must_choose'], 
	'checkbox' => $vbphrase['checkbox_multiple_options']
);


// ####################### Modify Settings ############################
if ($_REQUEST['do'] == 'modifysettings')
{
	$debug = '';

	$getphrases = $DB_site->query("SELECT varname, text FROM " . TABLE_PREFIX . "phrase WHERE phrasetypeid = 5000	ORDER BY languageid ASC");
	while($phrases = $DB_site->fetch_array($getphrases))
	{
		$settingphrase[$phrases['varname']] = $phrases['text'];
	}

	require_once('./includes/adminfunctions_options.php');

	$settings = $DB_site->query("
			SELECT adv_setting.*
			FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
			LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup USING (grouptitle)
			WHERE adv_settinggroup.grouptitle LIKE 'adv_links_%' AND optioncode != 'hidden'
			ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $DB_site->fetch_array($settings))
	{
		$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
		$grouptitlecache[$setting['grouptitle']] = $setting['grouptitle'];
	}

	$DB_site->free_result($settings);
	unset($setting);
	print_form_header('vba_links_admin', 'saveopts');

	foreach ($grouptitlecache AS $grouptitle)
	{
		print_setting_group($grouptitle);
		print_table_break();
	}
	print_submit_row();
}

// ####################### Save Settings ############################
if ($_POST['do'] == 'saveopts')
{
	globalize($_POST, array('setting'));

  foreach ($setting AS $varname => $value)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . addslashes($value) . "' WHERE varname = '$varname'");
	}

	$settings = $DB_site->query("SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting WHERE varname LIKE 'links%'");
	while ($setting = $DB_site->fetch_array($settings))
	{
		$adv_options["$setting[varname]"] = $setting['value'];
	}
	$DB_site->free_result($settings);
	unset($setting);

	build_datastore('adv_links_opts', serialize($adv_options));
	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=modifysettings", 0);
}

// ################## Edit Permissions For Usergroup #######################
if ($_REQUEST['do'] == 'permissions')
{

	globalize($_REQUEST, array('u' => INT));

	$usergroups = $DB_site->query("SELECT usergroupid, title FROM " . TABLE_PREFIX . "usergroup ORDER BY usergroupid");
	while ($usergroup = $DB_site->fetch_array($usergroups))
	{
		$grouparray[$usergroup['usergroupid']] = $usergroup['title'];
	}

	if ($u)
	{
		$usergroup = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "usergroup WHERE usergroupid = '$u'");
	}
	print_form_header('vba_links_admin', 'permissions');
	print_table_header(iif($usergroup['usergroupid'], $usergroup['title'], $vbphrase['modify_permissions']));

	print_description_row('' . $vbphrase['modify_usergroup'] . ': <select name="u" class="bginput" onchange="submit();">' . construct_select_options($grouparray, $u) . '</select> <input class="button" type="submit" value="' . $vbphrase['go'] . '" />', 0, 1, '', 'center');
	print_table_footer();

	if ($u)
	{
		print_form_header('vba_links_admin', 'updateperms');
	
		$perms = convert_bits_to_array($usergroup['linkspermissions'], $_BITFIELD['usergroup']['linkspermissions']);

		print_label_row('<b>' . $usergroup['title'] . '</b>', '<input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 1);" type="button" value="' . $vbphrase['all_yes'] . '" /> <input id="checkall2" name="checkall" onclick="js_check_all_option(this.form, 0);" type="button" value="' . $vbphrase['all_no'] . '" />', 'tcat');

		print_description_row($vbphrase['general_options'], 0, 2, 'thead');
		construct_hidden_code('usergroupid', $usergroup['usergroupid']);
		construct_hidden_code('usergrouptitle', $usergroup['title']);
		print_yes_no_row($vbphrase['can_view_links_directory'], 'usergroup[canviewlinksdir]', $perms['canviewlinksdir']);
		print_yes_no_row($vbphrase['can_view_links'], 'usergroup[canviewlinks]', $perms['canviewlinks']);
		print_yes_no_row($vbphrase['can_add_links'], 'usergroup[canaddlinks]', $perms['canaddlinks']);
		print_yes_no_row($vbphrase['moderate_this_groups_links'], 'usergroup[moderatelinks]', $perms['moderatelinks']);
		print_yes_no_row($vbphrase['moderate_this_groups_posts'], 'usergroup[moderateposts]', $perms['moderateposts']);
		print_yes_no_row($vbphrase['can_view_private_directories'], 'usergroup[canviewprivate]', $perms['canviewprivate']);
		print_yes_no_row($vbphrase['can_search_links'], 'usergroup[cansearchlinks]', $perms['cansearchlinks']);
		print_yes_no_row($vbphrase['can_send_link_friend'], 'usergroup[cansendlinktofriend]', $perms['cansendlinktofriend']);
	
		print_description_row($vbphrase['link_editing_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_edit_own_links'], 'usergroup[caneditlinks]', $perms['caneditlinks']);
		print_yes_no_row($vbphrase['can_edit_others_links'], 'usergroup[caneditotherslinks]', $perms['caneditotherslinks']);
		print_yes_no_row($vbphrase['can_delete_own_links'], 'usergroup[candelete]', $perms['candelete']);
		print_yes_no_row($vbphrase['can_delete_others_links'], 'usergroup[candeleteothers]', $perms['candeleteothers']);
	
		print_description_row($vbphrase['posting_options'], 0, 2, 'thead');
		print_yes_no_row($vbphrase['can_view_replies_to_links'], 'usergroup[canviewreplies]', $perms['canviewreplies']);
		print_yes_no_row($vbphrase['can_reply_to_links'], 'usergroup[canreplytolinks]', $perms['canreplytolinks']);
		print_yes_no_row($vbphrase['can_edit_own_posts'], 'usergroup[caneditposts]', $perms['caneditposts']);
		print_yes_no_row($vbphrase['can_edit_others_posts'], 'usergroup[caneditothersposts]', $perms['caneditothersposts']);
		print_yes_no_row($vbphrase['can_delete_own_posts'], 'usergroup[candeleteposts]', $perms['candeleteposts']);
		print_yes_no_row($vbphrase['can_delete_others_posts'], 'usergroup[candeleteothersposts]', $perms['candeleteothersposts']);
	
		print_yes_no_row($vbphrase['can_rate_links'], 'usergroup[canratelinks]', $perms['canratelinks']);

		print_submit_row($vbphrase['save_permissions']);
	}
}

// ######################## Do Update Permissions #####################
if ($_POST['do'] == 'updateperms')
{

	globalize($_POST, array('usergroup', 'usergroupid' => INT, 'usergrouptitle' => STR));

	require_once('./includes/functions_misc.php');
	$linkperms = convert_array_to_bits($usergroup, $_BITFIELD['usergroup']['linkspermissions'], 1);

	$DB_site->query("UPDATE " . TABLE_PREFIX . "usergroup SET linkspermissions = '$linkperms' WHERE usergroupid = '$usergroupid'");

	require_once('./includes/functions_databuild.php');
	build_forum_permissions();

	define('CP_REDIRECT', "vba_links_admin.php?$session[sessionurl]do=permissions");
	print_stop_message('saved_usergroup_x_successfully', $usergrouptitle);

}

// ############################# Manage Directories #########################
if ($_REQUEST['do'] == 'dirmanager')
{
	?>
	<script type="text/javascript">
	function js_dir_jump(dirid)
	{
		action = eval("document.cpform.c" + dirid + ".options[document.cpform.c" + dirid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit': 
				page = 'vba_links_admin.php?do=editcat&catid=';
				break;
			case 'remove': 
				page = 'vba_links_admin.php?do=deletecat&catid=';
				break;
			case 'addsub': 
				page = 'vba_links_admin.php?do=addcat&parentid=';
				break;
			case 'view': 
				page = 'vba_links_admin.php?do=viewlinks&catid=';
				break;
			case 'empty': 
				page = 'vba_links_admin.php?do=emptydir&catid=';
				break;
			case 'massdelete': 
				page = 'vba_links_admin.php?do=viewlinks&massedit=1&amp;catid=';
				break;
		}
		document.cpform.reset();

		window.location = page + dirid + "&s=<?php echo $session['sessionhash']; ?>";
	}

	function js_mod_jump(dirid)
	{
		modid = eval("document.cpform.m" + dirid + ".options[document.cpform.m" + dirid + ".selectedIndex].value");
		document.cpform.reset();
		switch (modid)
		{
			case 'addmod':
				window.location = "vba_links_admin.php?s=<?php echo $session['sessionhash']; ?>&do=addmoderator&catid=" + dirid;
				break;
			default:
				
				window.location = "vba_links_admin.php?s=<?php echo $session['sessionhash']; ?>&do=editmoderator&modid=" + modid + "&catid=" + dirid; break;
		}
	}

	</script>

	<?php

	$diroptions = array(
		'edit' => $vbphrase['edit_directory'],
		'view' => $vbphrase['view_directory'],
		'empty' => $vbphrase['empty_directory'],
		'remove' => $vbphrase['remove_directory'],
		'addsub' => $vbphrase['add_sub_directory'],
		'massdelete' => $vbphrase['mass_delete_suspend']
	);

	print_form_header('vba_links_admin', 'doorder');
	print_table_header($vbphrase['modify_links_directories'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['controls'], $vbphrase['display_order'], $vbphrase['moderator']), 1, 'tcat');
	
	$catinfo = array();
	
	$getcats = $DB_site->query("SELECT catid, title, parent, haslinks, displayorder FROM " . TABLE_PREFIX . "links_categories ORDER BY displayorder ASC, haslinks");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$DB_site->free_result($getcats);
	unset($categories);

	$linkmods = array();

	// Get Moderator Info
	$mods = $DB_site->query('SELECT * FROM ' . TABLE_PREFIX . 'links_moderator');
	while ($lmods = $DB_site->fetch_array($mods))
	{
		$linkmods[] = $lmods;
	}

	$DB_site->free_result($mods);
	unset($lmods);

	if ($linkmods)
	{
		foreach ($linkmods AS $moderator)
		{
			$moderator['musername'] = fetch_musername($moderator);
			$links_modcache[$moderator['catid']][$moderator['userid']] = $moderator;
		}
	}
	// Construct The Directories
	if ($catinfo = construct_directories($catinfo, 0, -1));
	{
		foreach ($catinfo as $cats)
		{
			// Figure out who moderates which directory
			if ($links_modcache[$cats['catid']])
			{
				$modcounts = 0;
				foreach($links_modcache[$cats['catid']] AS $moderator)
				{
					$modcounts++;
					$modopts[$cats['catid']] .= '<option value="' . $moderator['userid'] . '"> &nbsp; ' . $moderator['username'] . '</option>';
					$modcount[$cats['catid']] = $modcounts;
				}
			}

			$cell = array();

			$cell[] = '<b>' . str_repeat('- - ', ($cats['level'] - 1)) . ' <a href="vba_links_admin.php?' . $session['sessionhash'] . 'do=editcat&amp;catid=' . $cats['catid'] . '">' . stripslashes($cats['title']) . '</a></b>';

			$cell[] = '<select name="c' . $cats['catid'] . '" onchange="js_dir_jump(' . $cats['catid'] . ');" class="bginput">' . construct_select_options($diroptions) . '</select><input class="button" type="button" value="' . $vbphrase['go'] . '" onclick="js_dir_jump(' . $cats['catid'] . ');" />';

			$cell[] = '<input type="text" class="bginput" name="order[' . $cats['catid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $cats['displayorder'] . '" />';

			$cell[] = '<select class="bginput" name="m' . $cats['catid'] . '" onchange="js_mod_jump(' . $cats['catid']  . ');"><option value="0">' . $vbphrase['moderators'] . ' (' . number_format($modcount[$cats['catid']]) . ')</option>' . $modopts[$cats['catid']] . '<option value="addmod">' . $vbphrase['add_moderator'] . '</option></select><input class="button" onclick="js_mod_jump(' . $cats['catid'] . ');" type="button" value="' . $vbphrase['go'] . '" />';

			print_cells_row($cell);
	
		}
		unset($catinfo, $moderator, $links_modcache);
	}
	print_submit_row($vbphrase['update_order'], $vbphrase['reset'], 4);
}

// ####################### Re-Order Categories #########################
if ($_POST['do'] == 'doorder')
{
	globalize($_POST, array('order'));
  foreach ($order AS $key => $disorder)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET displayorder = '$disorder' WHERE catid = '$key'");
  }
	update_directory_cache();
	define('CP_REDIRECT', 'vba_links_admin.php' . $session['sessionurl']);
	print_stop_message('saved_display_order_successfully');
}

// ############################# Add/Edit Directory #########################
if (in_array($_REQUEST['do'], array('addcat', 'editcat')))
{

	globalize($_REQUEST, array('catid' => INT, 'parentid' => INT));

	print_form_header('vba_links_admin', iif($_REQUEST['do'] == 'addcat', 'doaddcat', 'doeditcat'));

	if ($_REQUEST['do'] == 'editcat')
	{
		$cat = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$catid'");
		construct_hidden_code('catid', $cat['catid']);
		construct_hidden_code('oldparentid', $cat['parent']);
		$options = convert_bits_to_array($cat['options'], $directoryopts);
	}
	else
	{
		$cat['parent'] = $parentid;
		$cat['haslinks'] = 1;
		$cat['private'] = 0;
		$options['open_for_links'] = 1;
		$options['open_for_posts'] = 1;
		$options['allow_post_bbcode'] = 1;
		$options['allow_post_smilies'] = 1;
		$options['allow_post_icons'] = 1;
		$options['allow_post_bbimgcode'] = 1;
		$options['allow_custom_bbcode'] = 1;
		$options['allow_custom_smilies'] = 1;
		$options['allow_custom_icons'] = 1;
		$options['allow_custom_bbimgcode'] = 1;
	}

	print_table_header(iif($_REQUEST['do'] == 'addcat', $vbphrase['add_new_directory'], $vbphrase['edit_directory'] . ' - ' . $cat['title'] . ' (' . $vbphrase['id'] . ': ' . $cat['catid'] . ')'));
	print_input_row("$vbphrase[title]:", 'title', stripslashes(unhtmlspecialchars($cat['title'])));
	print_textarea_row("$vbphrase[description]:", 'description', stripslashes(unhtmlspecialchars($cat['description'])));
	print_input_row("$vbphrase[display_order]:", 'displayorder', $cat['displayorder']);
	print_directory_select('parentid', $cat['parent'], $vbphrase['none'], $vbphrase['directory_parent']);

	print_table_header($vbphrase['directory_options']);
	print_input_row($vbphrase['email_address_to_notify_when_new_link'], 'newlinkemail', $cat['newlinkemail']);
	print_input_row($vbphrase['email_address_to_notify_when_new_post'], 'newpostemail', $cat['newpostemail']);
	print_yes_no_row($vbphrase['act_as_directory'], 'haslinks', $cat['haslinks']);
	print_yes_no_row($vbphrase['private_directory'], 'private', $cat['private']);
	print_yes_no_row($vbphrase['directory_is_open_for_links'], 'options[open_for_links]', $options['open_for_links']);
	print_yes_no_row($vbphrase['directory_is_open_for_posts'], 'options[open_for_posts]', $options['open_for_posts']);

	print_table_header($vbphrase['custom_fields']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_custom_html]', $options['allow_custom_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_custom_bbcode]', $options['allow_custom_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_custom_bbimgcode]', $options['allow_custom_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_custom_smilies]', $options['allow_custom_smilies']);

	print_table_header($vbphrase['posting_options']);
	print_yes_no_row($vbphrase['allow_html'], 'options[allow_post_html]', $options['allow_post_html']);
	print_yes_no_row($vbphrase['allow_bbcode'], 'options[allow_post_bbcode]', $options['allow_post_bbcode']);
	print_yes_no_row($vbphrase['allow_img_code'], 'options[allow_post_bbimgcode]', $options['allow_post_bbimgcode']);
	print_yes_no_row($vbphrase['allow_smilies'], 'options[allow_post_smilies]', $options['allow_post_smilies']);
	print_yes_no_row($vbphrase['allow_icons'], 'options[allow_post_icons]', $options['allow_post_icons']);

	print_submit_row($vbphrase['save']);
}

// ############################# Do Add / Edit Cat #########################
if (in_array($_POST['do'], array('doeditcat', 'doaddcat')))
{

	globalize($_POST, array('catid' => INT, 'title' => STR, 'description' => STR, 'haslinks' => INT, 'parentid' => INT, 'private' => INT, 'displayorder' => INT, 'options', 'newlinkemail' => STR, 'newpostemail' => STR));

	if (!trim($title))
	{
		print_stop_message('adv_links_cant_have_directory_without_title');
	}

	require_once('./includes/functions_misc.php');
	$options = convert_array_to_bits($options, $directoryopts);

	if ($_POST['do'] == 'doaddcat')
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "links_categories (title, description, haslinks, parent, displayorder, private, options, newlinkemail, newpostemail) VALUES ('" . addslashes(htmlspecialchars($title)) . "', '" . addslashes(htmlspecialchars($description)) . "', '$haslinks', '$parentid', '$displayorder', '$private', '$options', '" . addslashes($newlinkemail) . "', '" . addslashes($newpostemail) . "')");
	
		$newdirid = $DB_site->insert_id();
	
		if ($parentid)
		{
			$cat = $DB_site->query_first("SELECT parentlist FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$parentid'");
		}
	
		if ($cat['parentlist'])
		{
			$plist = $newdirid . ',' . $cat['parentlist'];
		}
		elseif ($parentid)
		{
			$plist = $newdirid . ',' . $parentid;
		}
		else
		{
			$plist = $newdirid;
		}
	
		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET parentlist = '$plist' WHERE catid = '$newdirid'");
	}
	else
	{
		if ($parentid == $catid)
		{
			print_stop_message('adv_links_cant_parent_directory_to_self');
		}
	
		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET title = '" . addslashes(htmlspecialchars($title)) . "', description = '" . addslashes(htmlspecialchars($description)) . "', parent = '$parentid', haslinks = '$haslinks', displayorder = '$_POST[displayorder]', private = '$_POST[private]', options = '$options', newlinkemail = '" . addslashes($newlinkemail) . "', newpostemail = '" . addslashes($newpostemail) . "' WHERE catid = '$catid'");
	
		if ($oldparentid != $parentid)
		{
			rebuild_parents($catid);
	
			$catinfo = array();
	
			$getcats = $DB_site->query("SELECT catid, parent FROM " . TABLE_PREFIX . "links_categories ORDER BY displayorder ASC, haslinks");
			while ($categories = $DB_site->fetch_array($getcats))
			{
				$catinfo[] = $categories;
			}
		
			$DB_site->free_result($getcats);
			unset($categories);
		
			if ($catinfo == construct_directories($catinfo, $catid, -1));
			{
				foreach ($catinfo as $cats)
				{
					rebuild_parents($cats['catid']);
				}
			}
		}
	}
		
	update_directory_cache();

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=dirmanager", 0);
}

// ############################# Delete Directory #########################
if ($_REQUEST['do'] == 'deletecat')
{

	globalize($_REQUEST, array('catid' => INT));

	print_form_header('vba_links_admin', 'dodeletecat');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_delete_directory']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Directory #########################
if ($_POST['do'] == 'dodeletecat')
{

	globalize($_POST, array('catid' => INT));

	$thiscat = $DB_site->query_first("SELECT title FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$catid'");

	$catinfo = array();

	$getcats = $DB_site->query("SELECT catid, parent FROM " . TABLE_PREFIX . "links_categories");
	while ($categories = $DB_site->fetch_array($getcats))
	{
		$catinfo[] = $categories;
	}

	$DB_site->free_result($getcats);
	unset($categories);

	$catids = array();

	if ($dirinfo = construct_directories($catinfo, $catid))
	{
		foreach ($dirinfo AS $cats)
		{
			$catids[] = $cats['catid'];
		}
	}

	if (is_array($catids))
	{
		$catarray = implode(',', array_merge($catid, $catids));
	}
	else
	{
		$catarray = $catid;
	}

	remove_links_in_cat($catarray);

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_categories WHERE catid IN ($catarray)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_subscribedir WHERE dirid IN ($catarray)");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_moderator WHERE catid IN ($catarray)");

	update_directory_cache();

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=dirmanager", 0);

}

// ############################# Empty Directory #########################
if ($_REQUEST['do'] == 'emptydir')
{
	globalize($_REQUEST, array('catid' => INT));

	print_form_header('vba_links_admin', 'doemptydir');
	construct_hidden_code('catid', $catid);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_empty_directory']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Empty Directory #########################
if ($_POST['do'] == 'doemptydir')
{
	globalize($_POST, array('catid' => INT));

	$thiscat = $DB_site->query_first("SELECT title FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$catid'");

	remove_links_in_cat($catid);

	$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET linkcount = 0, postcount = 0, lastlinkid = 0, lastlinktitle = '', lastposter = '', lastuserid = 0, lastupdated = 0 WHERE catid = '$catid'");

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=dirmanager", 0);
}

// ############################# Add Moderator #########################
if ($_REQUEST['do'] == 'addmoderator')
{
	globalize($_REQUEST, array('catid' => INT));

	$cat = $DB_site->query_first("SELECT catid, title FROM " . TABLE_PREFIX . "links_categories WHERE catid = '$catid'");
	print_form_header('vba_links_admin', 'doaddmod');
	print_table_header($vbphrase['add_moderator'] . '-' . stripslashes($cat['title']));
	construct_hidden_code('catid', $cat['catid']);
	construct_hidden_code('cattitle', $cat['title']);
	print_description_row($vbphrase['add_moderator_note_permissions']);
	print_input_row($vbphrase['username']. ':', 'username');
	print_submit_row();
}

// ############################# Do Add Moderator #########################
if ($_POST['do'] == 'doaddmod')
{
	globalize($_POST, array('catid' => INT, 'username' => STR));

	$user = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes(htmlspecialchars($username)) . "'");

	if (!$user['userid'])
	{
		print_stop_message('invalid_username_specified');
	}

	$ismod = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "links_moderator WHERE userid = '$user[userid]' AND catid = '$catid'");

	if ($ismod['userid'])
	{
		print_stop_message('user_is_already_mod');
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "links_moderator VALUES ('$user[userid]', '" . htmlspecialchars(addslashes($username)) . "', '$catid')");

	update_links_mod_cache();

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=dirmanager", 0);

}

// ############################ Edit Moderator ###########################
if ($_REQUEST['do'] == 'editmoderator')
{
	globalize($_REQUEST, array('catid' => INT, 'modid' => INT));

	$moderator = $DB_site->query_first("
			SELECT moderator.userid, moderator.username, moderator.catid, categories.title
			FROM " . TABLE_PREFIX . "links_moderator AS moderator
			INNER JOIN " . TABLE_PREFIX . "links_categories AS categories USING (catid)
			WHERE userid = '$modid' AND moderator.catid = '$catid'
	");

	if (!$moderator['userid'])
	{
		print_stop_message('invalid_user_specified');
	}		

	print_form_header('vba_links_admin', 'deletemod');
	construct_hidden_code('userid', $moderator['userid']);
	construct_hidden_code('catid', $moderator['catid']);
	print_table_header(construct_phrase($vbphrase['remove_x_from_moderating_y'], stripslashes($moderator['username']), stripslashes($moderator['title'])) . ' <input type="submit" value="' . $vbphrase['delete'] . '">');
	print_table_footer();
}


// ########################## Manage Custom Fields ########################
if ($_REQUEST['do'] == 'customfields')
{

	print_form_header('vba_links_admin', 'addcustomfield');
	print_table_header($vbphrase['add_custom_field']);
	print_select_row($vbphrase['custom_field_type'], 'type', $customfieldtypes);
	print_submit_row($vbphrase['continue'], '');

	print_form_header('vba_links_admin', 'ordercustom');
	print_table_header($vbphrase['custom_fields'], 4);
	print_cells_row(array($vbphrase['title'], $vbphrase['type'], $vbphrase['display_order'], $vbphrase['controls']), 0, 'thead', -1);

	$getfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "links_customfields ORDER BY displayorder");
	if ($DB_site->num_rows($getfields))
	{
		while ($fields = $DB_site->fetch_array($getfields))
		{
			$cells = array();
			$cells[] = $fields['title'];
			$cells[] = '<span class="smallfont">' . $customfieldtypes[$fields['type']] . '</span>';
			$cells[] = '<input class="bginput" name="order[' . $fields['fieldid'] . ']" size="3" type="text" value="'  . $fields['displayorder'] . '" />';
			$cells[] = 	construct_link_code($vbphrase['edit'], 'vba_links_admin.php?do=editcustomfield&amp;fieldid=' . $fields['fieldid']) . construct_link_code($vbphrase['delete'], 'vba_links_admin.php?do=removecustomfield&amp;fieldid=' . $fields['fieldid']);
			print_cells_row($cells, '', '', -1);
			
		}

		print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);

	}
	else
	{
		print_description_row($vbphrase['not_added_custom_fields'], '', 6);
	}	
	print_table_footer();

}

// ########################### Re-Order Custom Fields ########################
if ($_POST['do'] == 'ordercustom')
{
	globalize($_POST, array('order'));
  foreach ($order AS $key => $disorder)
  {
		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_customfields SET displayorder = '$disorder' WHERE fieldid = '$key'");
  }

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=customfields", 0);
}

// ############################## Add Custom Field ##########################
if (in_array($_REQUEST['do'], array('addcustomfield', 'editcustomfield')))
{

	globalize($_REQUEST, array('type' => STR_NOHTML, 'fieldid' => INT));

	print_form_header('vba_links_admin', 'do' . $_REQUEST['do']);

	if ($_REQUEST['do'] == 'editcustomfield')
	{
		$custom = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "links_customfields WHERE fieldid = '$fieldid'");
		construct_hidden_code('custom[fieldid]', $custom['fieldid']);
		$type = $custom['type'];
	}

	construct_hidden_code('custom[type]', $type);
	print_table_header(iif($_REQUEST['do'] == 'addcustomfield', $vbphrase['add_custom_field'] . ' - ' . $customfieldtypes[$type], $vbphrase['edit_custom_field'] . ' - ' . $custom['title']), 4);
	print_input_row($vbphrase['title'], 'custom[title]', $custom['title']);
	print_textarea_row($vbphrase['description'], 'custom[description]', $custom['description']);
	print_input_row($vbphrase['display_order'], 'custom[displayorder]', $custom['displayorder']);
	print_yes_no_row($vbphrase['field_required'], 'custom[required]', $custom['required']);
	print_yes_no_row($vbphrase['field_is_searchable'], 'custom[searchable]', iif($_REQUEST['do'] == 'addcustomfield', 1, $custom['searchable']));

	if (in_array($type, array('text', 'textarea')))
	{
		print_input_row($vbphrase['max_length_of_allowed_user_input'], 'custom[maxlength]', $custom['maxlength']);
	}
	else
	{
		print_textarea_row(construct_phrase($vbphrase['x_enter_the_options_that_the_user_can_choose_from'], $vbphrase['options']), 'custom[options]', $custom['options']);
	}

	print_submit_row();	
}

// ########################## Do Add Custom Field #########################
if (in_array($_POST['do'], array('doaddcustomfield', 'doeditcustomfield')))
{
	globalize($_POST, array('custom'));

	if (!empty($custom))
	{
		$cfields = array();
		foreach ($custom AS $key => $value)
		{
			$cfields[$key] = htmlspecialchars($value);
		}
	}

	$DB_site->query(fetch_query_sql($cfields, 'links_customfields', iif($_POST['do'] == 'doeditcustomfield', 'WHERE fieldid =  ' . $custom['fieldid'])));

	if ($_POST['do'] == 'doaddcustomfield')
	{
		$newfieldid = $DB_site->insert_id();
		$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "links_customfields_entries ADD field$newfieldid MEDIUMTEXT NOT NULL");
	}

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=customfields", 0);
	
}

// ########################## Delete Custom Field #########################
if ($_REQUEST['do'] == 'removecustomfield')
{
	$custom = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "links_customfields WHERE fieldid = '$_REQUEST[fieldid]'");
	
	print_form_header('vba_links_admin', 'doremovecustomfield');
	print_table_header($vbphrase['confirm_deletion']);
	construct_hidden_code('fieldid', $custom['fieldid']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_delete_the_x_called_y'], $vbphrase['custom_fields'], $custom['title'], $vbphrase['id'], $custom['fieldid'], ''));
	print_submit_row($vbphrase['yes'], $vbphrase['no']);
}

// ######################## Do Delete Custom Field ########################
if ($_POST['do'] == 'doremovecustomfield')
{
	globalize($_POST, array('fieldid' => INT));
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_customfields WHERE fieldid = '$fieldid'");
	$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "links_customfields_entries DROP field$fieldid");

	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=customfields", 0);

}

// ########################## Do Edit Moderator #########################
if ($_POST['do'] == 'deletemod')
{
	globalize($_POST, array('catid' => INT, 'userid' => INT));

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "links_moderator WHERE userid = '$userid' AND catid = '$catid'");
	update_links_mod_cache();
	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=dirmanager", 0);
}

// ############################# Add / Edit Link #########################
if (in_array($_REQUEST['do'], array('addlink', 'editlink')))
{
	globalize($_REQUEST, array('linkid' => INT, 'cw' => INT));

	print_form_header('vba_links_admin', iif($_REQUEST['do'] == 'addlink', 'doaddlink', 'doeditlink'));

	if ($_REQUEST['do'] == 'editlink')
	{
		$link = $DB_site->query_first("
				SELECT links.*, customfields.*
				FROM " . TABLE_PREFIX . "links AS links
				LEFT JOIN " . TABLE_PREFIX . "links_customfields_entries AS customfields ON (links.linkid = customfields.lid)
				WHERE linkid = '$linkid'
		");
	
		construct_hidden_code('linkid', $link['linkid']);
		construct_hidden_code('oldcatid', $link['catid']);
		construct_hidden_code('closewin', $cw);
	}

  print_table_header(iif($_REQUEST['do'] == 'addlink', $vbphrase['add_a_link'], '<span style="float:' . $stylevar['right'] . '">(' . iif($link['userid'], '<a href="' . $vboptions['bburl'] . '/member.php?u=' . $link['userid'] . '">' . $link['username'] . '</a>', $vbphrase['unregistered']) . ') &nbsp; ' . vbdate($vboptions['dateformat'] . ' ' . $vboptions['timeformat'], $link['dateline']) . '</span>' . $vbphrase['edit_link'] . ': ' . stripslashes($link['name']) . ' (' . $vbphrase['id'] . ':' . $link['linkid'] . ')'), 2, 0, '', 'left');
	print_input_row($vbphrase['title'] . ':', 'name', unhtmlspecialchars(stripslashes($link['name'])));
	print_input_row($vbphrase['url'] . ':', 'linkurl', $link['url']);
	print_textarea_row($vbphrase['description'] . ':', 'description', unhtmlspecialchars(stripslashes($link['description'])), 5, 34);
	print_directory_select('catid', $link['catid'], $vbphrase['please_choose_a_directory'], $vbphrase['directory'], true);
	print_input_row($vbphrase['keywords'] . ':', 'keywords', $link['keywords']);
	print_input_row($vbphrase['views'] . ':', 'views', intval($link['views']));
	if ($_REQUEST['do'] == 'addlink')
	{
		print_input_row($vbphrase['submitted_by'] . ':', 'username', unhtmlspecialchars(stripslashes($bbuserinfo['username'])));
	}
	print_yes_no_row($vbphrase['valid'] . ':', 'validatelink', iif($_REQUEST['do'] == 'editlink', $link['valid'], 1));
	print_yes_no_row($vbphrase['open'] . ':', 'openlink', iif($_REQUEST['do'] == 'editlink', $link['open'], 1));
	print_yes_no_row($vbphrase['sticky'] . ':', 'sticklink', $link['sticky']);
	print_yes_no_row($vbphrase['suspended'] . ':', 'suspendlink', $link['suspended']);

	construct_custom_fieldbits($link, iif($_REQUEST['do'] == 'addlink', false, true), true);

	print_submit_row(iif($_REQUEST['do'] == 'editlink', $vbphrase['save'], $vbphrase['add_a_link']));

}


// ############################# Do Add New Link #########################
if ($_POST['do'] == 'doaddlink')
{
	globalize($_POST, array('catid' => INT, 'username' => STR, 'name' => STR, 'linkurl' => STR, 'description' => STR, 'keywords' => STR, 'views' => INT, 'validatelink' => INT, 'sticklink' => INT, 'openlink' => INT, 'suspendlink' => INT));

	verify_link_errors();

	if ($username == $bbuserinfo['username'])
	{
		$userid = $bbuserinfo['userid'];
	}
	else
	{
		$username = htmlspecialchars(addslashes($username));
		$user = $DB_site->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '$username'");
		$userid = $user['userid'];
		if (!$userid)
		{
			print_stop_message('invalid_user_specified');
		}
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "links (catid, name, url, description, keywords, views, valid, username, userid, dateline, sticky, suspended, open) VALUES ('$catid', '" . addslashes(htmlspecialchars($name)) . "', '" . addslashes(htmlspecialchars($linkurl)) . "', '" . addslashes(htmlspecialchars($description)) . "', '" . addslashes(htmlspecialchars($keywords)) . "', '$views', '$validatelink', '" . addslashes(htmlspecialchars($username)) . "', '$userid', '" . time() . "', '$sticklink', '$suspendlink', '$openlink')");
	$newlinkid = $DB_site->insert_id();

	construct_customfields_sql($newlinkid);

	if ($validatelink AND !$suspendlink)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET linkcount = linkcount+1, lastlinkid = '$newlinkid', lastlinktitle = '" . addslashes(htmlspecialchars($name)) . "', lastposter = '" . addslashes(htmlspecialchars($username)) . "', lastuserid = '$userid', lastupdated = " . time() . " WHERE catid = '$catid'");
	}     

	print_stop_message('your_link_has_been_added');
}

// ############################# Do Edit Link #########################
if ($_POST['do'] == 'doeditlink')
{
	globalize($_POST, array('linkid' => INT, 'catid' => INT, 'username' => STR, 'name' => STR, 'linkurl' => STR, 'description' => STR, 'keywords' => STR, 'views' => INT, 'validatelink' => INT, 'sticklink' => INT, 'openlink' => INT, 'suspendlink' => INT, 'oldcatid' => INT, 'closewin' => INT));

	verify_link_errors();

	$link = $DB_site->query_first("SELECT valid, suspended FROM " . TABLE_PREFIX . "links WHERE linkid = '$linkid'");

	$DB_site->query("UPDATE " . TABLE_PREFIX . "links SET name = '" . addslashes(htmlspecialchars($name)) . "', url = '" . addslashes(htmlspecialchars($linkurl)) . "', description = '" . addslashes(htmlspecialchars($description)) . "', keywords = '" . addslashes(htmlspecialchars($keywords)) . "', views = '$views', valid = '$validatelink', suspended = '$suspendlink', sticky = '$sticklink', open = '$openlink', catid = '$catid' WHERE linkid = '$linkid'");

	construct_customfields_sql($linkid, false);

	if ($link['suspended'] != $suspendlink OR $link['valid'] != $validatelink)
	{
		update_count($catid);
		$newcatupdate = true;
	}

	if ($oldcatid != $catid)
	{
		if (!$newcatupdate)
		{
			update_count($catid);
		}
		update_count($oldcatid);
	}

	if ($closewin) 
	{
		define('CP_REDIRECT', "vba_links_admin.php?$session[sessionurl]do=closebox");
		print_stop_message('link_has_been_updated');
	}
	else
	{
		print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=viewlinks", 0);
	}
}

// ############################# Delete Link #########################
if ($_REQUEST['do'] == 'deletelink')
{
	globalize($_REQUEST, array('linkid' => INT));
	
	$link = $DB_site->query_first("SELECT linkid, name, catid FROM " . TABLE_PREFIX . "links WHERE linkid = '$linkid'");
	if (!$link['linkid'])
	{
		print_stop_message('invalid_x_specified', 'linkid');
	}
	print_form_header('vba_links_admin', 'dodeletelink');
	construct_hidden_code('catid', $link['catid']);
	construct_hidden_code('linkid', $linkid);
	construct_hidden_code('closewin', $cw);
	
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_link'], stripslashes($link['name'])));
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ############################# Do Delete Link #########################
if ($_POST['do'] == 'dodeletelink')
{
	globalize($_POST, array('linkid' => INT, 'closewin' => INT, 'catid' => INT));

	$link = $DB_site->query_first("SELECT name, posts FROM " . TABLE_PREFIX . "links WHERE linkid = '$linkid'");
	$postcount = intval($link['postcount']);

	$cat = $DB_site->query_first("SELECT linkid, name, dateline, username, userid FROM " . TABLE_PREFIX . "links WHERE catid = '$catid' AND suspended = 0 AND valid = 1 AND linkid != '$linkid' ORDER BY dateline DESC LIMIT 1");

	$DB_site->query("UPDATE " . TABLE_PREFIX . "links_categories SET linkcount = linkcount-1, postcount = postcount-$postcount, lastlinkid = '$cat[linkid]', lastlinktitle = '" . addslashes($cat['name']) . "', lastuserid = '$cat[userid]', lastupdated = '$cat[dateline]', lastposter = '" . addslashes($cat['username']) . "' WHERE catid = '$catid'");

	delete_links($linkid);

	if ($closewin) 
	{
		define('CP_REDIRECT', "vba_links_admin.php?$session[sessionurl]do=closebox");
		print_stop_message('deleted_x_successfully', 'link');
	}
	else
	{
		print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=viewlinks", 0);
	}
}

// ############################ JavaScript Close ############################
if ($_REQUEST['do'] == 'closebox')
{
	?>
	<html>
	<head>
	</head>
	<body>
	<script type="text/javascript">
	  window.close();
	</script>
	</body>
	</html>
	<?
}

// ############################# View Links #########################
if ($_REQUEST['do'] == 'viewlinks')
{
	globalize($_REQUEST, array('orderby' => STR, 'direction' => STR, 'perpage' => INT, 'catid' => INT, 'delarray', 'susarray', 'hiddendelarray', 'hiddensusarray', 'linkaction', 'domassedit' => STR, 'condition' => STR, 'newcatid' => INT, 'neworderby' => STR, 'newperpage' => INT, 'perpage' => INT, 'direction' => STR, 'newdirection' => STR, 'pagenumber' => INT, 'massedit' => INT));

	// Merge selected and make hidden code for suspended & deleted links
	if ($linkaction)
	{
		if (empty($delarray))
		{
			$delarray = array();
		}
		if (empty($susarray))
		{
			$susarray = array();
		}

		if ($hiddensusarray)
		{
			$susarray = array($hiddensusarray);
		}

		if ($hiddendelarray)
		{
			$delarray = array($hiddendelarray);
		}

		foreach ($linkaction AS $key => $val)
		{
			if ($val == 'suspend')
			{
				$susarray = array_merge($key, $susarray);
			}
			if ($val == 'delete')
			{
				$delarray = array_merge($key, $delarray);
			}
		}
		$delhidden = implode(',', $delarray);
		$sushidden = implode(',', $susarray);
	}
	else
	{
		$delhidden = $hiddendelarray;
		$sushidden = $hiddensusarray;
	}

	if ($domassedit)
	{
		$_REQUEST['do'] = 'confirmmassedit';
	}
	else
	{
		if ($condition)
		{
			$headerarray[] = $vbphrase['status'];
		}
		if ($massedit)
		{
			$headerarray[] = $vbphrase['controls'];
		}
		
		$headerarray[] = $vbphrase['title'];
		
		$extraquery = '';

		if ($newcatid)
		{
			$catid = $newcatid;
		}
		if ($newperpage)
		{
			$perpage = $newperpage;
		}
		if ($newdirection)
		{
			$direction = $newdirection;
		}
	
		if ($catid AND $catid != -1)
		{
			$extraquery .= "WHERE links.catid = $catid";
		}
		else
		{
			$headerarray[] = $vbphrase['directory'];
			$showdirs = true;
		}

		if ($condition AND $condition != 'all')
		{
			if ($extraquery)
			{
				$extraquery .= ' AND ';
			}
			else
			{
				$extraquery .='WHERE ';
			}

			if ($condition == 'suspended')
			{
				$extraquery = 'WHERE suspended = 1';
			}
			else
			{
				$extraquery = 'WHERE suspended != 1';
			}
		}

		if (!$condition)
		{
			$headerarray[] = $vbphrase['replies'];
			$headerarray[] = $vbphrase['views'];
			$headerarray[] = $vbphrase['date_added'];
		}			

		if ($neworderby)
		{
			$orderby = $neworderby;
		}
		$doorderby = construct_orderby();

		if ($orderby == 'rating')
		{
			$votequery = "IF(votenum >= $vboptions[showvotes], votenum, 0) AS votenum, IF(votenum >= $vboptions[showvotes] AND votenum> 0, votetotal / votenum, 0) AS voteavg,";
		}

		if ($direction != 'DESC')
		{
			$direction = 'ASC';
		}
	
	 	$countlinks = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "links $extraquery");

		if (!intval($pagenumber))
		{
			$pagenumber = 1;
		}

		if (empty($perpage))
		{
			$perpage = 50;
		}

		$pagecount = ceil($countlinks['count'] / $perpage);
		$minlimit = intval(($pagenumber - 1) * $perpage + 1);
		$maxlimit = intval($pagenumber * $perpage);
		
		if ($maxlimit > $countlinks['count'])
		{
			$maxlimit = $countlinks['count'];
			if ($minlimit > $countlinks['count'])
			{
			  $minlimit = $countlinks['count'] - $perpage;
			}
		}
		if ($minlimit <= 0)
		{
		  $minlimit = 1;
		}

	  print_form_header('vba_links_admin', 'viewlinks');

		construct_hidden_code('hiddendelarray', $delhidden);
		construct_hidden_code('hiddensusarray', $sushidden);
		construct_hidden_code('condition', $condition);
		construct_hidden_code('catid', $catid);
		construct_hidden_code('orderby', $orderby);
		construct_hidden_code('massedit', $massedit);
		construct_hidden_code('direction', $direction);
		construct_hidden_code('perpage', $perpage);

		print_table_header(construct_phrase($vbphrase['showing_links_x_to_y_of_z'], $minlimit, $maxlimit, $countlinks['count']));
		print_directory_select('newcatid', $catid, $vbphrase['all_directories'], $vbphrase['showing_links_in'], true, -1);

		print_select_row($vbphrase['order_by'] . ':', 'neworderby', $orderopts, $orderby);
	  
		print_select_row($vbphrase['direction'] . ':', 'newdirection', $diropts, $direction);
	
		print_select_row($vbphrase['per_page'] . ':', 'newperpage', $perpageopts, $perpage);
	
		print_description_row('<input class="button" type="submit" value="' . $vbphrase['show_links'] . '" /> <input class="button" type="reset" value="  ' . $vbphrase['reset'] . '  " />', '', 2, 'thead', 'center');
		print_table_break();

		if ($massedit)
		{
			print_table_header('<input id="checkall" name="checkall" onclick="js_check_all_option(this.form, \'delete\');" type="radio" /> ' . $vbphrase['delete_all'] . ' <input id="checkall" name="checkall" onclick="js_check_all_option(this.form, \'suspend\');" type="radio" /> ' . $vbphrase['suspend_all'] . ' <input id="checkall" name="checkall" onclick="js_check_all_option(this.form, 0);" type="radio" /> ' . $vbphrase['ignore_all'] . '', 6);
		}
	
		print_cells_row($headerarray, 1, 'tcat');

		$getlinks = $DB_site->query("
				SELECT $votequery links.*, links_categories.catid, links_categories.title 
				FROM " . TABLE_PREFIX . "links AS links
				LEFT JOIN " . TABLE_PREFIX . "links_categories AS links_categories ON (links.catid = links_categories.catid) 
				$extraquery 
				ORDER BY $doorderby $direction 
				LIMIT " . ($minlimit - 1) . ", $perpage
		");
	
		if ($DB_site->num_rows($getlinks))
		{
			$page_status = '';
			$statuscode = '';
			$target = '';
			$close = '';
		
			while ($links = $DB_site->fetch_array($getlinks))
			{
				if ($condition)
				{
					if ($simplecheck)
					{
						$page = @fopen($links['url'], 'r');
						if (!$page)
						{
							$statuscode = '<font color="red" size="1">' . $vbphrase['notfound'] . '</font>';
						}
						else
						{
							$statuscode = '<font color="green" size="1">' . $vbphrase['ok'] . '</fon>';
						}
					}
					else
					{
						$status = check_url($links['url']);
						$statuscode = '<span class="smallfont">' . $status['status'] . '</font>';
					}
				}
				if ($condition OR $massedit)
				{
					$target = 'target="_blank"';
					$close = '&amp;cw=1';
				}
				$cell = array();
		
				if ($condition)
				{
					$cell[] = $statuscode;
				}
				if ($massedit)
				{
					$cell[] = '<nobr><span class="smallfont">
						<label for="dellink[' . $links['linkid'] . ']"><input id="dellink[' . $links['linkid'] . ']" name="linkaction[' . $links['linkid'] . ']" type="radio" value="delete" />' . $vbphrase['delete'] . '</label>
						<label for="suslink[' . $links['linkid'] . ']"><input id="suslink[' . $links['linkid'] . ']" name="linkaction[' . $links['linkid'] . ']" type="radio" value="suspend" />' . $vbphrase['suspend'] . '</label>
						<label for="ignlink[' . $links['linkid'] . ']"><input id="ignlink[' . $links['linkid'] . ']" name="linkaction[' . $links['linkid'] . ']" type="radio" value="0" />' . $vbphrase['ignore'] . '</label></span></nobr>';
				}
					
		
				$cell[] = '<b>' . stripslashes($links['name']) . '</b> ' . iif($links['suspended'], '(<font color="red" size="1">' . $vbphrase['suspended'] . '</font>)') . ' ' . iif(!$links['valid'], '(<font color="yellow" size="1">' . $vbphrase['awaiting_moderation'] . '</font>)') . ' <br /><div class="smallfont">
					<nobr><a href="' . $links['url'] . '" target="_blank">[' . $vbphrase['view_site'] . ']</a>
					<a href="vba_links_admin.php?do=editlink&amp;catid=' . $catid . '&amp;linkid=' . $links['linkid'] . '' . $close . '" ' . $target . '>[' . $vbphrase['edit'] . ']</a>
					<a href="vba_links_admin.php?do=deletelink&catid=' . $catid . '&linkid=' . $links['linkid'] . '' . $close . '" ' . $target . '>[' . $vbphrase['delete'] . ']</a></nobr>
					</div>';

				if ($showdirs)
				{
					$cell[] = stripslashes($links['title']);
				}

				if (!$condition)
				{
					$cell[] = '<div align="center">' . number_format($links['posts']) . '</div>';
					$cell[] = '<div align="center">' . number_format($links['views']) . '</div>';
					$cell[] = '<div align="right" class="smallfont"><nobr>' . vbdate($vboptions['dateformat'] . ' ' . $vboptions['timeformat'], $links['dateline']) . '</nobr><br />' . $vbphrase['by'] . ' ' . iif($links['username'], '<a href="' . $vboptions['bburl'] . '/member.php?' . $session['sessionurl'] . 'u=' . $links['userid'] . '" target="_blank">' . stripslashes($links['username']) . '</a>', $vbphrase['guest']) . '</div>';
				}		
				print_cells_row($cell, '', '', -2);
			}

			if ($pagecount > 1)
			{
				$pagenav = $vbphrase['pages'] . '(' . $pagecount . ') &nbsp; ';
				$i = 0;
				while ($i++ < $pagecount)
				{
					$pagenav .= '<input class="button" name="pagenumber" type="submit" value="' . iif($i > 9, $i, " $i ") . '"' . iif($i == $pagenumber, ' disabled="disabled"') . ' /> ';
				}
			}
	
			print_table_header($pagenav, 6);
	
			if ($massedit)
			{
				print_table_footer(6, '<center><input type="submit" class="button" name="domassedit" value="' . $vbphrase['delete_suspend'] . '" style="font-weight:bold" tabindex="1" /> <input type="reset" tabindex="2" value="     ' . $vbphrase['reset'] . '     " style="font-weight:bold" /></center>', 0, $colspan);
			}
			print_table_footer();
		}
		else
		{
			print_description_row('<b>' . $vbphrase['no_links_matched_query'] . '</b>', '', 6, '', 'center');
			print_table_footer();
		}
	}
}

// ######################## Confirm Mass Delete ###############################
if ($_REQUEST['do'] == 'confirmmassedit')
{
	globalize($_POST, array('deletelink', 'delhidden', 'sushidden'));

	print_form_header('vba_links_admin', 'domassdelete');

	if (is_array($deletelink))
	{
		$lids = array();
		foreach ($deletelink AS $link => $dodelete)
		{
			if ($dodelete)
			{
				$lids[] = $link;
			}
		}
		if (is_array($lids))
		{
			$delhidden = implode(',', $lids);
		}
	}

	if ($delhidden)
	{
		print_table_header($vbphrase['you_have_chosen_to_delete_links'], 4);
		print_cells_row(array($vbphrase['delete'], $vbphrase['link_name'], $vbphrase['directory'], $vbphrase['date_added']), 'tcat');
		$dellinks = $DB_site->query("SELECT links.*, links_categories.title
				FROM " . TABLE_PREFIX . "links AS links
				LEFT JOIN " . TABLE_PREFIX . "links_categories AS links_categories USING (catid)
				WHERE linkid IN ($delhidden)
		");
		while ($dlink = $DB_site->fetch_array($dellinks))
		{
			print_sus_del_row($dlink, 1);
		}
		$DB_site->free_result($dellinks);
		unset($dlink);
		print_table_break();
	}
	
	if ($sushidden)
	{
		print_table_header($vbphrase['you_have_chosen_to_suspend_links'], 4);
		print_cells_row(array($vbphrase['suspend'], $vbphrase['link_name'], $vbphrase['directory'], $vbphrase['date_added']), 'tcat');
		$suslinks = $DB_site->query("SELECT links.*, links_categories.title
				FROM " . TABLE_PREFIX . "links AS links
				LEFT JOIN " . TABLE_PREFIX . "links_categories AS links_categories USING (catid)
				WHERE linkid IN ($sushidden)
		");
		while ($slink = $DB_site->fetch_array($suslinks))
		{
			print_sus_del_row($slink);
		}
		$DB_site->free_result($suslinks);
		unset($slink);
	}

	if (!$delhidden AND !$sushidden)
	{
		print_table_header($vbphrase['error']);
		print_description_row($vbphrase['must_choose_links_delete_suspend']);
		print_table_break();
	}
	else
	{
		print_table_break();
		print_submit_row();
	}
}

// ############################ Do Mass Delete #########################
if ($_POST['do'] == 'domassdelete')
{
	globalize($_POST, array('dellink', 'suslink'));
	if (is_array($dellink))
	{
		foreach ($dellink AS $key => $value)
		{
			delete_links($key);
			$blargle .= construct_phrase($vbphrase['deleted_link_key'], $key);
		}
	}

	echo '<br />';	
	if (is_array($suslink))
	{
		foreach ($suslink AS $key => $value)
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "links SET suspended = 1 WHERE linkid = '$key'");
			$blargle .= construct_phrase($vbphrase['suspended_link_key'], $key);
		}
	}
	echo $blargle;
	update_count(1);
	print_cp_redirect("vba_links_admin.php?$session[sessionurl]&do=viewlinks", 0);

}

// #################### Check duplicates ###################
if ($_REQUEST['do'] == 'checkdupes')
{
	print_form_header('vba_links_admin', 'confirmmassedit');
	print_table_header($vbphrase['find_duplicate_links']);
	print_table_break();

	$linkarray = array();

	$links = $DB_site->query('SELECT linkid, url, name, userid, username, dateline, title 
			FROM ' . TABLE_PREFIX . 'links AS links
			LEFT JOIN ' . TABLE_PREFIX . 'links_categories USING (catid)
	');
	while ($link = $DB_site->fetch_array($links))
	{
		$linkarray[] = $link;
	}

	$DB_site->free_result($links);
	unset($link);

	foreach($linkarray AS $link)
	{
		find_duplicates($linkarray, $link['url']);
	}
	print_submit_row($vbphrase['delete'], '', 6);
}


// ############################# Maintenance #########################
if ($_REQUEST['do'] == 'maintenance')
{

	// Check Duplicates
	print_form_header('vba_links_admin', 'checkdupes');
	print_table_header($vbphrase['find_duplicate_links']);
	print_description_row($vbphrase['find_duplicate_links_desc']);
	print_submit_row($vbphrase['find_duplicate_links'], '');

	// Verify Links
  print_form_header('vba_links_admin', 'viewlinks');
  print_table_header($vbphrase['verify_links']);
	construct_hidden_code('massedit', 1);
	print_description_row($vbphrase['verify_links_note']);

	$condopts = array('all' => $vbphrase['all_links'], 'suspended' => $vbphrase['only_suspended_links'], 'notsuspended' => $vbphrase['only_not_suspended_links']);

	print_select_row("$vbphrase[show]:", 'condition', $condopts);
	print_directory_select('catid', '0', $vbphrase['all_directories'], $vbphrase['directory']);
	print_select_row("$vbphrase[order_by]:", 'orderby', $orderopts);
	print_select_row("$vbphrase[direction]:", 'direction', $diropts);
	print_select_row("$vbphrase[per_page]:", 'perpage', $perpageopts);
	print_submit_row($vbphrase['verify_links']);

	// Update Directory Counters
	print_form_header('vba_links_admin', 'updatecounters');
	print_table_header($vbphrase['update_directories']);
	print_description_row(
		'<table width="100%" cellpadding="0" cellspacing="3"><tr><td>' . $vbphrase['update_directories_counters_desc'] . '</td>
		<td nowrap="nowrap"><input checked="checked" name="linkcount" type="checkbox" value="1" /> ' . $vbphrase['link_counts'] . '<br />
		<input checked="checked" name="postcount" type="checkbox" value="1" /> ' . $vbphrase['post_counts'] . '<br />
		<input checked="checked" name="lastlinks" type="checkbox" value="1" /> ' . $vbphrase['last_link_info']  . '
		</td></tr></table>'
	);
	print_submit_row($vbphrase['update_counters'], '');


	print_form_header('vba_links_admin', 'updatelastpost');
	print_table_header($vbphrase['update_last_posts']);
	print_description_row($vbphrase['update_last_posts_desc']);
	print_submit_row($vbphrase['update_counters'], '');

}

// #################### Update Counters #################
if ($_REQUEST['do'] == 'updatecounters')
{
	globalize($_REQUEST, array('linkcount' => INT, 'postcount' => INT, 'lastlinks' => INT));

	if (!$linkcount AND !$postcount AND !$lastlinks)
	{
		print_stop_message('adv_links_must_choose_update');
	}
	update_count(0, $linkcount, $postcount, $lastlinks);
	define('CP_REDIRECT', 'vba_links_admin.php?do=maintenance');
	print_stop_message('adv_links_updated_counters');
}

// ###################### Update Last Post #############################
if ($_REQUEST['do'] == 'updatelastpost')
{
	$links = $DB_site->query("SELECT linkid, lastpostdateline, lastpostuserid, lastpostusername, posts FROM " . TABLE_PREFIX . "links");
	while ($link = $DB_site->fetch_array($links))
	{
		$posts = $DB_site->query_first("SELECT COUNT(*) AS count, userid, dateline, username FROM " . TABLE_PREFIX . "links_posts WHERE linkid = '$link[linkid]' AND visible = 1 GROUP BY linkid ORDER BY dateline DESC");

		if (($link['lastpostdateline'] != $posts['dateline'] AND $posts['dateline']) OR $link['posts'] != $posts['count'])
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "links SET posts = '$posts[count]', lastpostdateline = '$posts[dateline]', lastpostuserid = '$posts[userid]', lastpostusername = '$posts[username]' WHERE linkid = '$link[linkid]'");
		}
		unset($posts);
	}

	define('CP_REDIRECT', 'vba_links_admin.php?do=maintenance');
	print_stop_message('adv_links_updated_counters');

}

// ###################### Rebuild Parent Lists #########################
if ($_REQUEST['do'] == 'rebuildparents')
{
	rebuild_parents();
}

// ########################### Update Directory Cache ##########################
if ($_REQUEST['do'] == 'updatecache')
{
	update_directory_cache();
}

print_cp_footer();

?>